<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2013-09-25 14:24
 */
interface RepresentativecompanyDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Representativecompany 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param representativecompany primary key
 	 */
	public function delete($representativecompanyId);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Representativecompany representativecompany
 	 */
	public function insert($representativecompany, $otherInfo);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Representativecompany representativecompany
 	 */
	public function update($representativecompany, $otherInfo);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByRepresentativeName($value);

	public function queryByRepresentativePhone($value);

	public function queryByCompanyId($value);

	public function queryByOtherInfo($value);


	public function deleteByRepresentativeName($value);

	public function deleteByRepresentativePhone($value);

	public function deleteByCompanyId($value);

	public function deleteByOtherInfo($value);


}
?>